// Camera.cpp: Implementierung der Klasse CCamera.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Camera.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// Conversion factor for converting between degrees and radians
#define PI_OVER_180 0.0174532925f

//////////////////////////////////////////////////////////////////////
// Construcktion/Destrucktion
//////////////////////////////////////////////////////////////////////

CCamera::CCamera()
{
	// Default construcktor: init all member variables to default values
	m_XPos = 0.0f;
	m_YPos = 0.0f;
	m_ZPos = 0.0f;
	m_YRotate = 0.0f;
	m_UpDown = 0.0f;
	m_WalkBiasAngle = 0.0f;
	m_WalkBias = 0.0f;
	m_SizeOfViewer = 0.03f;
	m_Speed = 0.004f;
}

CCamera::~CCamera()
{

}

void CCamera::RotateHorizontal(float fDegrees)
{
	// Rotate horizontal
	m_YRotate += fDegrees;

	// Check range
	if (m_YRotate < 0.0f)
		m_YRotate = 360.0f - (float) fabs(fDegrees);
	if (m_YRotate > 360.0f)
		m_YRotate = 0.0f + (float) fabs(fDegrees);
}

void CCamera::RotateVertical(float fDegrees)
{
	// Rotate vertikal
	m_UpDown += fDegrees;

	// Check range
	if (m_UpDown > 90.0f)
		m_UpDown = 90.0f;
	if (m_UpDown < -90.0f)
		m_UpDown = -90.0f;
}

void CCamera::CenterVertical()
{
	// Center the vertical axis of the camera
	m_UpDown = 0.0f;
}

bool CCamera::CheckCollision(float fPointAfter[])
{
	// Does camera collide with something when it moves to fPointAfter ?

	// Camera position before movement
	float fPointBefore[] = {m_XPos, m_YPos + m_SizeOfViewer, m_ZPos};
	
	// Check the triangle array for collisions
	for (int i=0; i <= m_Landscape.m_TriangleCount; i++)
	{
		// Collision with the current triangle ?
		if (m_Landscape.m_Triangles[i].CheckCollision(fPointBefore, fPointAfter) == TRUE)
		{
			// Yes; end loop
			return TRUE;
		}
	}
	
	// No collision
	return FALSE;
}

void CCamera::Move(bool bForward, bool bBackward, bool bStrafeLeft, bool bStrafeRight)
{
	// Move the camera

	// Base position for the movement
	float New_m_XPos = m_XPos;
	float New_m_ZPos = m_ZPos;

	// Should the camera move forward ?
	if (bForward == TRUE)
	{
		// Calculate new position
		New_m_XPos -= (float) sin(m_YRotate * PI_OVER_180) * m_Speed;
		New_m_ZPos -= (float) cos(m_YRotate * PI_OVER_180) * m_Speed;
	}

	// Should the camera move backward ?
	if (bBackward == TRUE)
	{
		// Calculate new position
		New_m_XPos += (float) sin(m_YRotate * PI_OVER_180) * m_Speed;
		New_m_ZPos += (float) cos(m_YRotate * PI_OVER_180) * m_Speed;
	}

	// Should the camera strafe left ?
	if (bStrafeLeft == TRUE)
	{
		// Calculate new position
		New_m_XPos += (float) sin((m_YRotate - 90) * PI_OVER_180) * m_Speed;
		New_m_ZPos += (float) cos((m_YRotate - 90) * PI_OVER_180) * m_Speed;
	}

	// Should the camera strafe right ?
	if (bStrafeRight == TRUE)
	{
		// Calculate new position
		New_m_XPos -= (float) sin((m_YRotate - 90) * PI_OVER_180) * m_Speed;
		New_m_ZPos -= (float) cos((m_YRotate - 90) * PI_OVER_180) * m_Speed;
	}

	// Camera position after movement
	float fPointAfter[]  = {New_m_XPos, m_YPos + m_SizeOfViewer, New_m_ZPos};

	// Collision ?
	if (CheckCollision(fPointAfter) == FALSE)
	{
		// Set new position
		m_XPos = New_m_XPos;
		m_ZPos = New_m_ZPos;
	
		// Calculate the new walkbias
		if (m_WalkBiasAngle <= 30.0f)
			m_WalkBiasAngle = 359.0f;
		else m_WalkBiasAngle+= 10;
		m_WalkBias = (float) sin(m_WalkBiasAngle * PI_OVER_180) / 20.0f;
	}
}

void CCamera::TransformWorld()
{
	// Transform the world

	// Transformation variables
	GLfloat fXTrans, fZTrans, fYTrans;
	GLfloat fSceneRotY;
	
	// Calculate translations & rotations
	fXTrans = -m_XPos;
	fZTrans = -m_ZPos;
	fSceneRotY = 360.0f - m_YRotate;
	// Walkbias
	fYTrans = -m_YPos + (-m_WalkBias) / 17.0f;
	// Size of viewer
	fYTrans -= m_SizeOfViewer;

	// Do translations & rotations
	glRotatef(m_UpDown, 1.0f, 0.0f , 0.0f);
	glRotatef(fSceneRotY, 0.0f, 1.0f, 0.0f);
	glTranslatef(fXTrans, fYTrans, fZTrans);
}